/***************************************************************************
 *
 *   BSD LICENSE
 *
 *   Copyright(c) 2023 Intel Corporation. All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ***************************************************************************/

#ifndef QATZIP_KM_H_
#define QATZIP_KM_H_

#include "qatzip.h"

typedef int (*QzInitFn)(QzSession_T *sess, unsigned char sw_backup);

typedef int (*QzSetupSessionFn)(QzSession_T *sess, QzSessionParams_T *params);

typedef int (*QzCompressFn)(QzSession_T *sess,
                            const unsigned char *src,
                            unsigned int *src_len,
                            unsigned char *dest,
                            unsigned int *dest_len,
                            unsigned int last);

typedef int (*QzCompressCrcFn)(QzSession_T *sess,
                               const unsigned char *src,
                               unsigned int *src_len,
                               unsigned char *dest,
                               unsigned int *dest_len,
                               unsigned int last,
                               unsigned long *crc);

typedef int (*QzDecompressFn)(QzSession_T *sess,
                              const unsigned char *src,
                              unsigned int *src_len,
                              unsigned char *dest,
                              unsigned int *dest_len);

typedef int (*QzTeardownSessionFn)(QzSession_T *sess);

typedef int (*QzCloseFn)(QzSession_T *sess);

typedef int (*QzGetStatusFn)(QzSession_T *sess, QzStatus_T *status);

typedef unsigned int (*QzMaxCompressedLengthFn)(unsigned int src_sz,
                                                QzSession_T *sess);

typedef int (*QzSetDefaultsFn)(QzSessionParams_T *defaults);

typedef int (*QzGetDefaultsFn)(QzSessionParams_T *defaults);

typedef void *(*QzMallocFn)(size_t sz, int numa, int forced_pinned);

typedef void (*QzFreeFn)(void *m);

typedef int (*QzMemFindAddrFn)(unsigned char *a);

typedef int (*QzCompressStreamFn)(QzSession_T *sess,
                                  QzStream_T *strm,
                                  unsigned int last);

typedef int (*QzDecompressStreamFn)(QzSession_T *sess,
                                    QzStream_T *strm,
                                    unsigned int last);

typedef int (*QzEndStreamFn)(QzSession_T *sess, QzStream_T *strm);

typedef int (*QzGetSoftwareComponentVersionListFn)(
    QzSoftwareVersionInfo_T *api_info,
    unsigned int *num_elem);

typedef int (*QzGetSoftwareComponentCountFn)(unsigned int *num_components);

typedef int (*QzSetupSessionDeflateFn)(QzSession_T *sess,
                                       QzSessionParamsDeflate_T *params);

typedef int (*QzSetupSessionLZ4Fn)(QzSession_T *sess,
                                   QzSessionParamsLZ4_T *params);

typedef int (*QzSetupSessionLZ4SFn)(QzSession_T *sess,
                                    QzSessionParamsLZ4S_T *params);

typedef int (*QzSetDefaultsDeflateFn)(QzSessionParamsDeflate_T *defaults);

typedef int (*QzSetDefaultsLZ4Fn)(QzSessionParamsLZ4_T *defaults);

typedef int (*QzSetDefaultsLZ4SFn)(QzSessionParamsLZ4S_T *defaults);

typedef int (*QzGetDefaultsDeflateFn)(QzSessionParamsDeflate_T *defaults);

typedef int (*QzGetDefaultsLZ4Fn)(QzSessionParamsLZ4_T *defaults);

typedef int (*QzGetDefaultsLZ4SFn)(QzSessionParamsLZ4S_T *defaults);

typedef int (*QzCompressExtFn)(QzSession_T *sess,
                               const unsigned char *src,
                               unsigned int *src_len,
                               unsigned char *dest,
                               unsigned int *dest_len,
                               unsigned int last,
                               uint64_t *ext_rc);

typedef int (*QzDecompressExtFn)(QzSession_T *sess,
                                 const unsigned char *src,
                                 unsigned int *src_len,
                                 unsigned char *dest,
                                 unsigned int *dest_len,
                                 uint64_t *ext_rc);

typedef int (*QzCompressCrc64Fn)(QzSession_T *sess,
                                 const unsigned char *src,
                                 unsigned int *src_len,
                                 unsigned char *dest,
                                 unsigned int *dest_len,
                                 unsigned int last,
                                 uint64_t *crc);

typedef int (*QzCompressCrc64ExtFn)(QzSession_T *sess,
                                    const unsigned char *src,
                                    unsigned int *src_len,
                                    unsigned char *dest,
                                    unsigned int *dest_len,
                                    unsigned int last,
                                    uint64_t *crc,
                                    uint64_t *ext_rc);

typedef int (*QzDecompressCrcExtFn)(QzSession_T *sess,
                                    const unsigned char *src,
                                    unsigned int *src_len,
                                    unsigned char *dest,
                                    unsigned int *dest_len,
                                    unsigned long *crc,
                                    uint64_t *ext_rc);

typedef int (*QzDecompressCrcFn)(QzSession_T *sess,
                                 const unsigned char *src,
                                 unsigned int *src_len,
                                 unsigned char *dest,
                                 unsigned int *dest_len,
                                 unsigned long *crc);

typedef int (*QzDecompressCrc64ExtFn)(QzSession_T *sess,
                                      const unsigned char *src,
                                      unsigned int *src_len,
                                      unsigned char *dest,
                                      unsigned int *dest_len,
                                      uint64_t *crc,
                                      uint64_t *ext_rc);

typedef int (*QzDecompressCrc64Fn)(QzSession_T *sess,
                                   const unsigned char *src,
                                   unsigned int *src_len,
                                   unsigned char *dest,
                                   unsigned int *dest_len,
                                   uint64_t *crc);

typedef int (*QzGetSessionCrc64Config)(QzSession_T *sess,
                                       QzCrc64Config_T *crc64_config);

typedef int (*QzSetSessionCrc64Config)(QzSession_T *sess,
                                       QzCrc64Config_T *crc64_config);

typedef int (*QzAllocateMetadataFn)(QzMetadataBlob_T *metadata,
                                    size_t data_size,
                                    uint32_t hw_buff_sz);

typedef int (*QzFreeMetadataFn)(QzMetadataBlob_T metadata);

typedef int (*QzMetadataBlockReadFn)(uint32_t block_num,
                                     QzMetadataBlob_T metadata,
                                     uint32_t *block_offset,
                                     uint32_t *block_size,
                                     uint32_t *block_flags,
                                     uint32_t *block_hash);

typedef int (*QzMetadataBlockWriteFn)(uint32_t block_num,
                                      QzMetadataBlob_T metadata,
                                      uint32_t *block_offset,
                                      uint32_t *block_size,
                                      uint32_t *block_flags,
                                      uint32_t *block_hash);

typedef int (*QzCompressWithMetadataExtFn)(QzSession_T *sess,
                                           const unsigned char *src,
                                           unsigned int *src_len,
                                           unsigned char *dest,
                                           unsigned int *dest_len,
                                           unsigned int last,
                                           uint64_t *ext_rc,
                                           QzMetadataBlob_T metadata,
                                           uint32_t hw_buff_sz_override,
                                           uint32_t comp_thrshold);

typedef int (*QzDecompressWithMetadataExtFn)(QzSession_T *sess,
                                             const unsigned char *src,
                                             unsigned int *src_len,
                                             unsigned char *dest,
                                             unsigned int *dest_len,
                                             uint64_t *ext_rc,
                                             QzMetadataBlob_T metadata,
                                             uint32_t hw_buff_sz_override);

typedef struct _QZ_FUNCTION_TABLE
{
    const QzInitFn qzInit;
    const QzSetupSessionFn qzSetupSession;
    const QzCompressFn qzCompress;
    const QzCompressCrcFn qzCompressCrc;
    const QzDecompressFn qzDecompress;
    const QzTeardownSessionFn qzTeardownSession;
    const QzCloseFn qzClose;
    const QzGetStatusFn qzGetStatus;
    const QzMaxCompressedLengthFn qzMaxCompressedLength;
    const QzSetDefaultsFn qzSetDefaults;
    const QzGetDefaultsFn qzGetDefaults;
    const QzMallocFn qzMalloc;
    const QzFreeFn qzFree;
    const QzMemFindAddrFn qzMemFindAddr;
    const QzCompressStreamFn qzCompressStream;
    const QzDecompressStreamFn qzDecompressStream;
    const QzEndStreamFn qzEndStream;
    const QzGetSoftwareComponentVersionListFn qzGetSoftwareComponentVersionList;
    const QzGetSoftwareComponentCountFn qzGetSoftwareComponentCount;
    const QzSetupSessionDeflateFn qzSetupSessionDeflate;
    const QzSetupSessionLZ4Fn qzSetupSessionLZ4;
    const QzSetupSessionLZ4SFn qzSetupSessionLZ4S;
    const QzSetDefaultsDeflateFn qzSetDefaultsDeflate;
    const QzSetDefaultsLZ4Fn qzSetDefaultsLZ4;
    const QzSetDefaultsLZ4SFn qzSetDefaultsLZ4S;
    const QzGetDefaultsDeflateFn qzGetDefaultsDeflate;
    const QzGetDefaultsLZ4Fn qzGetDefaultsLZ4;
    const QzGetDefaultsLZ4SFn qzGetDefaultsLZ4S;
    const QzCompressExtFn qzCompressExt;
    const QzDecompressExtFn qzDecompressExt;
    const QzCompressCrc64Fn qzCompressCrc64;
    const QzCompressCrc64ExtFn qzCompressCrc64Ext;
    const QzDecompressCrcFn qzDecompressCrc;
    const QzDecompressCrcExtFn qzDecompressCrcExt;
    const QzDecompressCrc64Fn qzDecompressCrc64;
    const QzDecompressCrc64ExtFn qzDecompressCrc64Ext;
    const QzGetSessionCrc64Config qzGetSessionCrc64Config;
    const QzSetSessionCrc64Config qzSetSessionCrc64Config;
    const QzAllocateMetadataFn qzAllocateMetadata;
    const QzFreeMetadataFn qzFreeMetadata;
    const QzMetadataBlockReadFn qzMetadataBlockRead;
    const QzMetadataBlockWriteFn qzMetadataBlockWrite;
    const QzCompressWithMetadataExtFn qzCompressWithMetadataExt;
    const QzDecompressWithMetadataExtFn qzDecompressWithMetadataExt;
} QZ_FUNCTION_TABLE, *PQZ_FUNCTION_TABLE;

typedef struct _QZ_IOCTL_OUTPUT_PARAMS
{
    PVOID pDispatchTable;
} QZ_IOCTL_OUTPUT_PARAMS, *PQZ_IOCTL_OUTPUT_PARAMS;

#define IOCTL_GET_QZ_INTERFACE \
    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x906, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif // QATZIP_KM_H_
